from flask import Markup
from psynet.timeline import (
    join
)
from psynet.page import (
    InfoPage,
    TextInputPage,
    NumberInputPage,
    NAFCPage
)

from questionnaire import (
    questions,
    choices
)

instructions_training = join(
    InfoPage(
        Markup("""
        <h1>Instructions</h1>
        <hr>
        <p>
            In this experiment, you will listen to sounds by moving a point on a slider. <br>
            You will be asked to pick the sound which best represents a property in question.
        </p>
        <img src="/static/images/slider_example.png" alt="Schematic figure of experimental task" style="width:450px">
        <hr>
        """),
        time_estimate=10
    ),
    InfoPage(
        Markup("""
        <h1>Instructions (cont.):</h1>
        <h3>
            We will now play some training examples to help you understand the format of the experiment.
            To be able to submit a response you must explore at least three different points on the slider.
        </h3>
        <img src="/static/images/explore.png" alt="Schematic figure of experimental task" style="width:450px">
        <hr>
        <p>
            <strong>Note:</strong> The quality of your responses will be checked automatically,
            and high quality responses will be bonused accordingly at the end of the experiment.
            The best strategy is to perform the task honestly and carefully, and then you will tend to give good results.
            Sometimes the sounds might take a moment to load, so please be patient.
        </p>
        <hr>
        """),
        time_estimate=10
    )
)

instructions_experiment = InfoPage(
    Markup("""
    <h1>Instructions (cont.):</h1>
    <h3>
        The actual experiment will begin now. Pay careful attention to the various sounds!
        Sometimes the differences between the sounds can be subtle, choose what seems most accurate to you.
    </h3>
    <p>
        <strong>Remember:</strong> the best strategy is just to honestly report what you think sounds better!
        You must explore at least three points on the slider before submitting a response.
        Also, sometimes the sounds might take a moment to load, so please be patient.
    </p>
    """),
    time_estimate=3
)

final_questionnaire= join(
    InfoPage(
        Markup("""
        <h3>Thank you for completing the task!</h3>
        <br>
        Before we finish,
        please answer a few final questions.
        """),
        time_estimate=3
    ),
    NumberInputPage(
        "age",
        "Please indicate your age in years.",
        time_estimate=3,
        one_line= True
    ),
    NAFCPage(
        label= "gender",
        prompt= "What is your gender?",
        choices= ["Female", "Male", "Other", "Prefer not to specify"],
        time_estimate=3,
        arrange_vertically=False
    ),
    TextInputPage(
        "country",
        Markup("""
            What country are you from?
            """),
        time_estimate=3,
        one_line=True
    ),
    TextInputPage(
        "mother_tongue",
        Markup("""
            What is your mother tongue?
            """),
        time_estimate=3,
        one_line=True
    ),
    NAFCPage(
        label= "musical_experience",
        prompt= questions["musical_experience"],
        choices= choices["musical_experience"],
        time_estimate=3,
        arrange_vertically=False
    ),
    NumberInputPage(
        label= "years_playing_music",
        prompt= questions["years_playing_music"],
        time_estimate=3,
        one_line= True
    ),
    TextInputPage(
        "which_instrument",
        Markup(
            questions["which_instrument"]
            ),
        time_estimate=5,
        one_line=False
    ),
    TextInputPage(
        "favourite_bands",
        Markup(
            questions["favourite_bands"]
            ),
        time_estimate=5,
        one_line=False
    ),
    TextInputPage(
        "last_song_heard",
        Markup(
            questions["last_song_heard"]
            ),
        time_estimate=5,
        one_line=False
    ),
    NAFCPage(
        label= "hearing_issues",
        prompt= questions["hearing_issues"],
        choices= choices["hearing_issues"],
        time_estimate=3,
        arrange_vertically=False
    ),
    NAFCPage(
        label= "education",
        prompt= questions["education"],
        choices= choices["education"],
        time_estimate=3,
        arrange_vertically=False
    ),
    TextInputPage(
        "feedback",
        Markup("""
            Did you like the experiment?
            """),
        time_estimate=5,
        one_line=False
    ),
    TextInputPage(
        "technical_problems",
        Markup("""
            Did you encounter any technical problems during the
            experiment? <br>If so, please provide a few words describing the
            problem.
            """),
        time_estimate=5,
        one_line=False
    )
)

